package com.hero.ui;

import com.hero.HeroDesigner;
import com.hero.Rules;
import com.hero.objects.GenericObject;
import com.hero.objects.List;
import com.hero.objects.martialarts.ExtraDamageClasses;
import com.hero.objects.martialarts.Maneuver;
import com.hero.objects.martialarts.RangedDamageClasses;
import com.hero.objects.martialarts.WeaponElement;
import com.hero.ui.widgets.PopupMessage;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class ManeuversList extends GenericObjectList {

	private static final long serialVersionUID = -4523013734394019082L;

	public ManeuversList() {
		super("Martial Arts", "Cost", "Maneuver", "END", HeroDesigner
				.getActiveHero().getManeuvers());
	}

	@Override
	public void addObject(GenericObject o) {
		if (HeroDesigner.getActiveHero().isPrefab()) {
			super.addObject(o);
			return;
		}
		boolean ret = true;
		boolean warned = false;
		Rules rules = HeroDesigner.getActiveHero().getRules();
		if (rules.getManeuverMaxResponse() > Rules.IGNORE) {
			// check values...
			double total = 0;
			for (int i = 0; i < HeroDesigner.getActiveHero().getManeuvers()
					.size(); i++) {
				GenericObject o2 = HeroDesigner.getActiveHero().getManeuvers()
						.get(i);
				total += o2.getRealCostPreList();
			}
			int avail = rules.getManeuverMaxValue();
			if ((total > avail) && (o.getRealCostPreList() > 0)) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"Total points of purchased Martial Arts exceeds allowed maximum.",
								rules.getManeuverMaxResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getManeuverMaxResponse() == Rules.WARN;
			} else if ((total + o.getRealCostPreList() > avail)
					&& (o.getRealCostPreList() > 0)) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This purchase puts the total Martial Arts points used over the allowable limit.",
								rules.getManeuverMaxResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getManeuverMaxResponse() == Rules.WARN;
			}
		}
		if (!warned && (rules.getAvailTotalPointsResponse() > Rules.IGNORE)) {
			double newVal = o.getRealCostPreList();
			if (newVal > 0) {
				double total = HeroDesigner.getActiveHero().getSpentTotal();
				total += newVal;
				double avail = HeroDesigner.getActiveHero().getBasePoints()
						+ HeroDesigner.getActiveHero().getDisadPoints()
						+ HeroDesigner.getActiveHero().getExperience();
				if (HeroDesigner.getActiveTemplate().is6E()) {
					avail -= HeroDesigner.getActiveHero().getDisadPoints();
				}
				if (total > avail) {
					PopupMessage popup = PopupMessage
							.getInstance(
									HeroDesigner.getAppFrame(),
									this,
									"This purchase puts the total points used over the available total for the character.",
									rules.getAvailTotalPointsResponse() == Rules.WARN);
					popup.setVisible(true);
					warned = true;
					ret = rules.getAvailTotalPointsResponse() == Rules.WARN;
				}
			}
		}
		if (!warned && (rules.getAttackAPMaxResponse() > Rules.IGNORE)
				&& o.getTypes().contains("ATTACK")) {
			double active = o.getActiveCost();
			if (active > rules.getAttackAPMaxValue()) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This Attack exceeds the maximum Active Points for an Attack set in the campaign rules.",
								rules.getAttackAPMaxResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getAttackAPMaxResponse() == Rules.WARN;
			}
		}
		if (!warned && (rules.getDefenseAPMaxResponse() > Rules.IGNORE)
				&& o.getTypes().contains("DEFENSE")) {
			double active = o.getActiveCost();
			if (active > rules.getDefenseAPMaxValue()) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This Defense ability exceeds the maximum Active Points for a Defense ability set in the campaign rules.",
								rules.getDefenseAPMaxResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getDefenseAPMaxResponse() == Rules.WARN;
			}
		}
		if (ret) {
			super.addObject(o);
		}
	}

	@Override
	protected boolean checkPaste() {
		if (HeroDesigner.getCopyBuffer() == null) {
			return false;
		}
		GenericObject obj = HeroDesigner.getCopyBuffer();
		if (obj instanceof List) {
			List l = (List) obj;
			for (int i = 0; i < l.getObjects().size(); i++) {
				GenericObject o = l.getObjects().get(i);
				if (!((o instanceof Maneuver)
						|| (o instanceof ExtraDamageClasses)
						|| (o instanceof RangedDamageClasses) || (o instanceof WeaponElement))) {
					return false;
				}
			}
		} else if (!((obj instanceof Maneuver)
				|| (obj instanceof ExtraDamageClasses)
				|| (obj instanceof RangedDamageClasses) || (obj instanceof WeaponElement))) {
			return false;
		}
		return true;
	}

	@Override
	protected boolean checkReplace(GenericObject replacement,
			GenericObject replacee) {
		if (HeroDesigner.getActiveHero().isPrefab()) {
			return true;
		}
		boolean ret = true;
		boolean warned = false;
		Rules rules = HeroDesigner.getActiveHero().getRules();
		if (rules.getManeuverMaxResponse() > Rules.IGNORE) {
			// check values...
			double total = 0;
			for (int i = 0; i < HeroDesigner.getActiveHero().getManeuvers()
					.size(); i++) {
				GenericObject o2 = HeroDesigner.getActiveHero().getManeuvers()
						.get(i);
				total += o2.getRealCostPreList();
			}
			int avail = rules.getManeuverMaxValue();
			if ((total > avail)
					&& (replacement.getRealCostPreList() > replacee
							.getRealCostPreList())) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This edit puts the total Martial Arts points used over the allowed limit.",
								rules.getManeuverMaxResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getManeuverMaxResponse() == Rules.WARN;
			} else if (total - replacee.getRealCostPreList()
					+ replacement.getRealCostPreList() > avail) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This edit puts the total Martial Arts points used over the allowed limit.",
								rules.getManeuverMaxResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getManeuverMaxResponse() == Rules.WARN;
			}
		}
		if (!warned && (rules.getAvailTotalPointsResponse() > Rules.IGNORE)) {
			double oldVal = replacee.getRealCostPreList();
			double newVal = replacement.getRealCostPreList();
			if (newVal > oldVal) {
				double total = HeroDesigner.getActiveHero().getSpentTotal();
				total -= oldVal;
				total += newVal;
				double avail = HeroDesigner.getActiveHero().getBasePoints()
						+ HeroDesigner.getActiveHero().getDisadPoints()
						+ HeroDesigner.getActiveHero().getExperience();
				if (HeroDesigner.getActiveTemplate().is6E()) {
					avail -= HeroDesigner.getActiveHero().getDisadPoints();
				}
				if (total > avail) {
					PopupMessage popup = PopupMessage
							.getInstance(
									HeroDesigner.getAppFrame(),
									this,
									"This edit puts the total points used over the available total for the character.",
									rules.getAvailTotalPointsResponse() == Rules.WARN);
					popup.setVisible(true);
					warned = true;
					ret = rules.getAvailTotalPointsResponse() == Rules.WARN;
				}
			}
		}
		if (!warned && (rules.getAttackAPMaxResponse() > Rules.IGNORE)
				&& replacement.getTypes().contains("ATTACK")) {
			double active = replacement.getActiveCost();
			if ((active > rules.getAttackAPMaxValue())
					&& (active > replacee.getActiveCost())) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This Attack exceeds the maximum Active Points for an Attack set in the campaign rules.",
								rules.getAttackAPMaxResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getAttackAPMaxResponse() == Rules.WARN;
			}
		}
		if (!warned && (rules.getDefenseAPMaxResponse() > Rules.IGNORE)
				&& replacement.getTypes().contains("DEFENSE")) {
			double active = replacement.getActiveCost();
			if ((active > rules.getDefenseAPMaxValue())
					&& (active > replacee.getActiveCost())) {
				PopupMessage popup = PopupMessage
						.getInstance(
								HeroDesigner.getAppFrame(),
								this,
								"This Defense ability exceeds the maximum Active Points for a Defense ability set in the campaign rules.",
								rules.getDefenseAPMaxResponse() == Rules.WARN);
				popup.setVisible(true);
				warned = true;
				ret = rules.getDefenseAPMaxResponse() == Rules.WARN;
			}
		}
		return ret;
	}
}